/*
 * SplitStoryChains.jsx
 * Javascript for InDesign CS5, CS4, CS3
 * Version date: 20101112
 * 
 * Splits the selected story into separate (i.e., unthreaded) text frames.
 * 
 * Note: Any overset text at the end of the story will be deleted.
 * Note: Hyphenation points between text frames will not be retained.
 * 
 * For more on InDesign scripting, go to http://www.adobe.com/products/indesign/xml_scripting.html
 * or visit the InDesign Scripting User to User forum at http://www.adobeforums.com
 * 
 * DISCLAIMER:
 * ===============
 * Absolutely no warranty. Use it as is or modify it to match your needs
 *
 * Author: Andreas Imhof, www.aiedv.ch
 */

var scriptpath = getScriptsPath();
var callscript = "/zz_Utilities/SplitStoryChainsPerPage.jsx";
if (scriptpath.indexOf("zz_Utilities") >= 0) callscript = "/SplitStoryChainsPerPage.jsx";
var scriptFile = new File(getScriptsPath() + callscript);
app.scriptArgs.setValue("splitAllTextFrames", "1");
//try {
	app.doScript(scriptFile,ScriptLanguage.javascript);
//} catch (e) {}
var numSplittedStoryBoxes = parseInt(app.scriptArgs.getValue("totalSplittedTextFrames"));

var str_totalSplittableTextFrames = "" + numSplittedStoryBoxes;
app.scriptArgs.setValue("totalSplittedTextFrames", str_totalSplittableTextFrames);

app.scriptArgs.setValue("splitAllTextFrames", "0");


function getScriptsPath() {
	var fullpath = app.activeScript;
	var scriptFile = new File(fullpath);
	return(scriptFile.path);
}
